<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Delivery extends Model 
{

    protected $table = 'deliveries';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'address', 'phone', 'national_id', 'notes');

    public function orders()
    {
        return $this->hasMany('App\Models\Order');
    }

    public function clients()
    {
        return $this->belongsToMany('App\Models\Client');
    }

}